/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindCIDRsToCommaDelimitedQueryParam
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof Iterable, "this binder is only valid for Iterables!");
        Iterable cidrs = (Iterable)Preconditions.checkNotNull(input, "cidr list");
        Preconditions.checkArgument(Iterables.size(cidrs) > 0, "you must specify at least one cidr range");
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParam("cidrlist", Joiner.on(',').join(cidrs))).build();
    }
}

