/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.logging.Logger;

@Singleton
public class VirtualMachineDestroyed
implements Predicate<VirtualMachine> {
    private final CloudStackClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public VirtualMachineDestroyed(CloudStackClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(VirtualMachine virtualMachine) {
        this.logger.trace("looking for state on virtualMachine %s", Preconditions.checkNotNull(virtualMachine, "virtualMachine"));
        virtualMachine = this.refresh(virtualMachine);
        if (virtualMachine == null) {
            return true;
        }
        this.logger.trace("%s: looking for virtualMachine state %s: currently: %s", new Object[]{virtualMachine.getId(), VirtualMachine.State.DESTROYED, virtualMachine.getState()});
        return virtualMachine.getState() == VirtualMachine.State.DESTROYED;
    }

    private VirtualMachine refresh(VirtualMachine virtualMachine) {
        return this.client.getVirtualMachineClient().getVirtualMachine(virtualMachine.getId());
    }
}

