/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch;

import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.CloudWatchAsyncApi;
import org.jclouds.cloudwatch.config.CloudWatchRestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class CloudWatchApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 3450830053589179249L;
    public static final TypeToken<RestContext<CloudWatchApi, CloudWatchAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<CloudWatchApi, CloudWatchAsyncApi>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata(this);
    }

    public CloudWatchApiMetadata() {
        this(new Builder(CloudWatchApi.class, CloudWatchAsyncApi.class));
    }

    protected CloudWatchApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)Builder.class.cast(builder));
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("cloudwatch").name("Amazon CloudWatch Api").identityName("Access Key ID").credentialName("Secret Access Key").version("2010-08-01").documentation(URI.create("http://docs.amazonwebservices.com/AmazonCloudWatch/latest/APIReference/")).defaultEndpoint("https://monitoring.us-east-1.amazonaws.com").defaultProperties(CloudWatchApiMetadata.defaultProperties()).defaultModule(CloudWatchRestClientModule.class);
        }

        @Override
        public CloudWatchApiMetadata build() {
            return new CloudWatchApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

