/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ListMetricsOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Set<Dimension> dimensions = Sets.newLinkedHashSet();
    private String metricName;
    private String namespace;
    private Object afterMarker;

    public ListMetricsOptions namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ListMetricsOptions metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public ListMetricsOptions dimensions(Iterable<Dimension> dimensions) {
        Iterables.addAll(this.dimensions, dimensions);
        return this;
    }

    public ListMetricsOptions dimension(Dimension dimension) {
        this.dimensions.add(dimension);
        return this;
    }

    public ListMetricsOptions afterMarker(Object afterMarker) {
        this.afterMarker = afterMarker;
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        ImmutableMultimap.Builder<String, String> formParameters = ImmutableMultimap.builder();
        int dimensionIndex = 1;
        if (this.namespace != null) {
            formParameters.put("Namespace", this.namespace);
        }
        if (this.metricName != null) {
            formParameters.put("MetricName", this.metricName);
        }
        if (this.dimensions != null) {
            for (Dimension dimension : this.dimensions) {
                formParameters.put("Dimensions.member." + dimensionIndex + ".Name", dimension.getName());
                formParameters.put("Dimensions.member." + dimensionIndex + ".Value", dimension.getValue());
                ++dimensionIndex;
            }
        }
        if (this.afterMarker != null) {
            formParameters.put("NextToken", this.afterMarker.toString());
        }
        return formParameters.build();
    }

    public ListMetricsOptions clone() {
        return Builder.namespace(this.namespace).metricName(this.metricName).dimensions(this.dimensions).afterMarker(this.afterMarker);
    }

    public static class Builder {
        public static ListMetricsOptions namespace(String namespace) {
            return new ListMetricsOptions().namespace(namespace);
        }

        public static ListMetricsOptions metricName(String metricName) {
            return new ListMetricsOptions().metricName(metricName);
        }

        public static ListMetricsOptions dimensions(Iterable<Dimension> dimensions) {
            return new ListMetricsOptions().dimensions(dimensions);
        }

        public static ListMetricsOptions dimension(Dimension dimension) {
            return new ListMetricsOptions().dimension(dimension);
        }

        public static ListMetricsOptions afterMarker(Object afterMarker) {
            return new ListMetricsOptions().afterMarker(afterMarker);
        }
    }
}

