/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.deltacloud.domain;

import com.google.common.base.Preconditions;
import org.jclouds.deltacloud.domain.HardwareParameter;
import org.jclouds.deltacloud.domain.HardwareProperty;
import org.jclouds.deltacloud.domain.internal.BaseHardwareProperty;

public class ParameterizedHardwareProperty
extends BaseHardwareProperty {
    private final HardwareParameter param;

    public ParameterizedHardwareProperty(HardwareProperty.Kind kind, String name, String unit, Object value, HardwareParameter param) {
        super(kind, name, unit, value);
        this.param = Preconditions.checkNotNull(param, "param");
    }

    public HardwareParameter getParam() {
        return this.param;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.param == null ? 0 : this.param.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterizedHardwareProperty other = (ParameterizedHardwareProperty)obj;
        return !(this.param == null ? other.param != null : !this.param.equals(other.param));
    }

    @Override
    public String toString() {
        return "[kind=" + (Object)((Object)this.getKind()) + ", name=" + this.getName() + ", unit=" + this.getUnit() + ", value=" + this.getValue() + ", param=" + this.getParam() + "]";
    }
}

