/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.predicates;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.logging.Logger;

@Singleton
public class VolumeAttached
implements Predicate<Attachment> {
    private final ElasticBlockStoreClient client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public VolumeAttached(ElasticBlockStoreClient client) {
        this.client = client;
    }

    @Override
    public boolean apply(Attachment attachment) {
        this.logger.trace("looking for volume %s", attachment.getVolumeId());
        Volume volume = Iterables.getOnlyElement(this.client.describeVolumesInRegion(attachment.getRegion(), attachment.getVolumeId()));
        if (volume.getAttachments().size() == 0) {
            return false;
        }
        Attachment lastAttachment = Sets.newTreeSet(volume.getAttachments()).last();
        this.logger.trace("%s: looking for status %s: currently: %s", new Object[]{lastAttachment, Attachment.Status.ATTACHED, lastAttachment.getStatus()});
        return lastAttachment.getStatus() == Attachment.Status.ATTACHED;
    }
}

