/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindBlockDeviceMappingToIndexedFormParams;
import org.jclouds.ec2.binders.IfNotNullBindAvailabilityZoneToFormParam;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceStateChange;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.functions.ConvertUnencodedBytesToBase64EncodedString;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.ec2.xml.BlockDeviceMappingHandler;
import org.jclouds.ec2.xml.BooleanValueHandler;
import org.jclouds.ec2.xml.DescribeInstancesResponseHandler;
import org.jclouds.ec2.xml.GetConsoleOutputResponseHandler;
import org.jclouds.ec2.xml.InstanceInitiatedShutdownBehaviorHandler;
import org.jclouds.ec2.xml.InstanceStateChangeHandler;
import org.jclouds.ec2.xml.InstanceTypeHandler;
import org.jclouds.ec2.xml.RunInstancesResponseHandler;
import org.jclouds.ec2.xml.StringValueHandler;
import org.jclouds.ec2.xml.UnencodeStringValueHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface InstanceAsyncClient {
    @Named(value="ec2:DescribeInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeInstances"})
    @XMLResponseParser(value=DescribeInstancesResponseHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<? extends Reservation<? extends RunningInstance>>> describeInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="ec2:RunInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RunInstances"})
    @XMLResponseParser(value=RunInstancesResponseHandler.class)
    public ListenableFuture<? extends Reservation<? extends RunningInstance>> runInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @Nullable @BinderParam(value=IfNotNullBindAvailabilityZoneToFormParam.class) String var2, @FormParam(value="ImageId") String var3, @FormParam(value="MinCount") int var4, @FormParam(value="MaxCount") int var5, RunInstancesOptions ... var6);

    @Named(value="ec2:RebootInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RebootInstances"})
    public ListenableFuture<Void> rebootInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="ec2:TerminateInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"TerminateInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<Set<? extends InstanceStateChange>> terminateInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="ec2:StopInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"StopInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public ListenableFuture<Set<? extends InstanceStateChange>> stopInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="Force") boolean var2, String ... var3);

    @Named(value="ec2:StartInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"StartInstances"})
    @XMLResponseParser(value=InstanceStateChangeHandler.class)
    public ListenableFuture<Set<? extends InstanceStateChange>> startInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "userData"})
    @XMLResponseParser(value=UnencodeStringValueHandler.class)
    public ListenableFuture<String> getUserDataForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "rootDeviceName"})
    @XMLResponseParser(value=StringValueHandler.class)
    public ListenableFuture<String> getRootDeviceNameForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "ramdisk"})
    @XMLResponseParser(value=StringValueHandler.class)
    public ListenableFuture<String> getRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "kernel"})
    @XMLResponseParser(value=StringValueHandler.class)
    public ListenableFuture<String> getKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "disableApiTermination"})
    @XMLResponseParser(value=BooleanValueHandler.class)
    public ListenableFuture<Boolean> isApiTerminationDisabledForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "instanceType"})
    @XMLResponseParser(value=InstanceTypeHandler.class)
    public ListenableFuture<String> getInstanceTypeForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "instanceInitiatedShutdownBehavior"})
    @XMLResponseParser(value=InstanceInitiatedShutdownBehaviorHandler.class)
    public ListenableFuture<Volume.InstanceInitiatedShutdownBehavior> getInstanceInitiatedShutdownBehaviorForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:DescribeInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeInstanceAttribute", "blockDeviceMapping"})
    @XMLResponseParser(value=BlockDeviceMappingHandler.class)
    public ListenableFuture<? extends Map<String, BlockDevice>> getBlockDeviceMappingForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:ResetInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetInstanceAttribute", "ramdisk"})
    public ListenableFuture<Void> resetRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:ResetInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ResetInstanceAttribute", "kernel"})
    public ListenableFuture<Void> resetKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "userData"})
    public ListenableFuture<Void> setUserDataForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") @ParamParser(value=ConvertUnencodedBytesToBase64EncodedString.class) byte[] var3);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "ramdisk"})
    public ListenableFuture<Void> setRamdiskForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "kernel"})
    public ListenableFuture<Void> setKernelForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "disableApiTermination"})
    public ListenableFuture<Void> setApiTerminationDisabledForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") boolean var3);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "instanceType"})
    public ListenableFuture<Void> setInstanceTypeForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") String var3);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"ModifyInstanceAttribute", "instanceInitiatedShutdownBehavior"})
    public ListenableFuture<Void> setInstanceInitiatedShutdownBehaviorForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @FormParam(value="Value") Volume.InstanceInitiatedShutdownBehavior var3);

    @Named(value="ec2:ModifyInstanceAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ModifyInstanceAttribute"})
    public ListenableFuture<Void> setBlockDeviceMappingForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2, @BinderParam(value=BindBlockDeviceMappingToIndexedFormParams.class) Map<String, BlockDevice> var3);

    @Named(value="ec2:GetConsoleOutput")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetConsoleOutput"})
    @XMLResponseParser(value=GetConsoleOutputResponseHandler.class)
    public ListenableFuture<String> getConsoleOutputForInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="InstanceId") String var2);
}

