/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid;

import java.util.Set;
import org.jclouds.gogrid.domain.internal.ErrorResponse;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;

public class GoGridResponseException
extends HttpResponseException {
    private static final long serialVersionUID = 1924589L;
    private Set<ErrorResponse> errors;

    public GoGridResponseException(HttpCommand command, HttpResponse response, Set<ErrorResponse> errors) {
        super(GoGridResponseException.buildMessage(command, response, errors), command, response);
        this.setErrors(errors);
    }

    public Set<ErrorResponse> getError() {
        return this.errors;
    }

    public void setErrors(Set<ErrorResponse> errors) {
        this.errors = errors;
    }

    private static String buildMessage(HttpCommand command, HttpResponse response, Set<ErrorResponse> errors) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("command %s failed with code %s. ", command.toString(), response.getStatusCode()));
        for (ErrorResponse error : errors) {
            builder.append(String.format("Error [%s]: %s. ", error.getErrorCode(), error.getMessage()));
        }
        return builder.toString();
    }
}

