/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetJobListOptions
extends BaseHttpRequestOptions {
    public static final GetJobListOptions NONE = new GetJobListOptions();

    public GetJobListOptions maxItemsNumber(Integer maxNumber) {
        Preconditions.checkState(!this.queryParameters.containsKey("num_items"), "Can't have duplicate parameter of max returned items");
        this.queryParameters.put("num_items", maxNumber.toString());
        return this;
    }

    public GetJobListOptions withStartDate(Date startDate) {
        Preconditions.checkState(!this.queryParameters.containsKey("startdate"), "Can't have duplicate start date for filtering");
        this.queryParameters.put("startdate", String.valueOf(startDate.getTime()));
        return this;
    }

    public GetJobListOptions withEndDate(Date endDate) {
        Preconditions.checkState(!this.queryParameters.containsKey("enddate"), "Can't have duplicate end date for filtering");
        this.queryParameters.put("enddate", String.valueOf(endDate.getTime()));
        return this;
    }

    public GetJobListOptions withOwner(String owner) {
        Preconditions.checkState(!this.queryParameters.containsKey("owner"), "Can't have duplicate owner name for filtering");
        this.queryParameters.put("owner", owner);
        return this;
    }

    public GetJobListOptions onlyForState(JobState jobState) {
        Preconditions.checkState(!this.queryParameters.containsKey("job.state"), "Can't have duplicate job state for filtering");
        this.queryParameters.put("job.state", jobState.toString());
        return this;
    }

    public GetJobListOptions onlyForObjectType(ObjectType objectType) {
        Preconditions.checkState(!this.queryParameters.containsKey("job.objecttype"), "Can't have duplicate object type for filtering");
        this.queryParameters.put("job.objecttype", objectType.toString());
        return this;
    }

    public GetJobListOptions onlyForObjectName(String objectName) {
        Preconditions.checkState(!this.queryParameters.containsKey("object"), "Can't have duplicate object name for filtering");
        this.queryParameters.put("object", objectName);
        return this;
    }

    public GetJobListOptions latestJobForObjectByName(String serverName) {
        return this.maxItemsNumber(1).onlyForObjectName(serverName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetJobListOptions options = (GetJobListOptions)o;
        return ((Object)this.buildQueryParameters()).equals(options.buildQueryParameters());
    }

    public static class Builder {
        public static GetJobListOptions maxItems(int maxNumber) {
            return new GetJobListOptions().maxItemsNumber(maxNumber);
        }

        public static GetJobListOptions startDate(Date startDate) {
            return new GetJobListOptions().withStartDate(startDate);
        }

        public static GetJobListOptions latestJobForObjectByName(String serverName) {
            return new GetJobListOptions().latestJobForObjectByName(serverName);
        }
    }
}

