/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageAsyncApi;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.location.Provider;
import org.jclouds.openstack.keystone.v2_0.domain.Access;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;

@Singleton
public class HPCloudObjectStorageBlobRequestSigner
implements BlobRequestSigner {
    private final RestAnnotationProcessor<HPCloudObjectStorageAsyncApi> processor;
    private final Crypto crypto;
    private final com.google.inject.Provider<Long> unixEpochTimestampProvider;
    private final Supplier<Access> access;
    private final Supplier<Credentials> creds;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2HttpGetOptions;
    private final Method getMethod;
    private final Method deleteMethod;
    private final Method createMethod;

    @Inject
    public HPCloudObjectStorageBlobRequestSigner(RestAnnotationProcessor<HPCloudObjectStorageAsyncApi> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Crypto crypto, @TimeStamp com.google.inject.Provider<Long> unixEpochTimestampProvider, Supplier<Access> access, @Provider Supplier<Credentials> creds) throws SecurityException, NoSuchMethodException {
        this.processor = Preconditions.checkNotNull(processor, "processor");
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.unixEpochTimestampProvider = Preconditions.checkNotNull(unixEpochTimestampProvider, "unixEpochTimestampProvider");
        this.access = Preconditions.checkNotNull(access, "access");
        this.creds = Preconditions.checkNotNull(creds, "creds");
        this.blobToObject = Preconditions.checkNotNull(blobToObject, "blobToObject");
        this.blob2HttpGetOptions = Preconditions.checkNotNull(blob2HttpGetOptions, "blob2HttpGetOptions");
        this.getMethod = HPCloudObjectStorageAsyncApi.class.getMethod("getObject", String.class, String.class, GetOptions[].class);
        this.deleteMethod = HPCloudObjectStorageAsyncApi.class.getMethod("removeObject", String.class, String.class);
        this.createMethod = HPCloudObjectStorageAsyncApi.class.getMethod("putObject", String.class, SwiftObject.class);
    }

    @Override
    public HttpRequest signGetBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.getMethod, container, name));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        GeneratedHttpRequest request = this.processor.createRequest(this.getMethod, container, name);
        return BlobStoreUtils.cleanRequest(this.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.getMethod, container, name, this.blob2HttpGetOptions.apply(options)));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.createMethod, container, this.blobToObject.apply(blob)));
    }

    @Override
    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        GeneratedHttpRequest request = this.processor.createRequest(this.createMethod, container, this.blobToObject.apply(blob));
        return BlobStoreUtils.cleanRequest(this.signForTemporaryAccess(request, timeInSeconds));
    }

    @Override
    public HttpRequest signRemoveBlob(String container, String name) {
        return BlobStoreUtils.cleanRequest(this.processor.createRequest(this.deleteMethod, container, name));
    }

    private HttpRequest signForTemporaryAccess(HttpRequest request, long timeInSeconds) {
        Credentials currentCreds = Preconditions.checkNotNull(this.creds.get(), "credential supplier returned null");
        String accessKeyId = currentCreds.identity.substring(currentCreds.identity.indexOf(58) + 1);
        String secretKey = currentCreds.credential;
        String tenantId = this.access.get().getToken().getTenant().get().getId();
        HttpMessage.Builder builder = request.toBuilder();
        ((HttpRequest.Builder)builder).filters(Iterables.filter(request.getFilters(), Predicates.not(Predicates.instanceOf(AuthenticateRequest.class))));
        long expiresInSeconds = this.unixEpochTimestampProvider.get() + timeInSeconds;
        String signature = this.createSignature(secretKey, this.createStringToSign(request.getMethod().toUpperCase(), request, expiresInSeconds));
        ((HttpRequest.Builder)builder).addQueryParam("temp_url_sig", String.format("%s:%s:%s", tenantId, accessKeyId, signature));
        ((HttpRequest.Builder)builder).addQueryParam("temp_url_expires", "" + expiresInSeconds);
        return ((HttpRequest.Builder)builder).build();
    }

    private String createStringToSign(String method, HttpRequest request, long expiresInSeconds) {
        Preconditions.checkArgument(method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("PUT"));
        return String.format("%s\n%d\n%s", method.toUpperCase(), expiresInSeconds, request.getEndpoint().getPath());
    }

    private String createSignature(String key, String stringToSign) {
        try {
            return CryptoStreams.hex(this.crypto.hmacSHA1(key.getBytes()).doFinal(stringToSign.getBytes()));
        }
        catch (InvalidKeyException e) {
            throw Throwables.propagate(e);
        }
    }
}

