/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.extensions.CDNContainerApi;

@Singleton
public class EnableCDNAndCache
implements Function<String, URI> {
    private final LoadingCache<String, URI> cdnContainer;
    private final HPCloudObjectStorageApi sync;

    @Inject
    public EnableCDNAndCache(HPCloudObjectStorageApi sync, LoadingCache<String, URI> cdnContainer) {
        this.sync = sync;
        this.cdnContainer = cdnContainer;
    }

    @Override
    public URI apply(String input) {
        Optional<CDNContainerApi> cdnExtension = this.sync.getCDNExtension();
        Preconditions.checkArgument(cdnExtension.isPresent(), "CDN is required, but the extension is not available!");
        URI uri = cdnExtension.get().enable(input);
        this.cdnContainer.put(input, uri);
        return uri;
    }
}

