/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import org.jclouds.hpcloud.objectstorage.domain.CDNContainer;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.InvocationContext;

public class ParseCDNContainerFromHeaders
implements Function<HttpResponse, CDNContainer>,
InvocationContext<ParseCDNContainerFromHeaders> {
    private HttpRequest request;

    @Override
    public CDNContainer apply(HttpResponse from) {
        String cdnUri = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Uri"), "X-Cdn-Uri");
        String cdnTTL = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Ttl"), "X-Ttl");
        String cdnEnabled = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Cdn-Enabled"), "X-Cdn-Enabled");
        if (cdnUri == null) {
            return null;
        }
        ArrayList<String> parts = Lists.newArrayList(Splitter.on('/').split(this.request.getEndpoint().getPath()));
        return CDNContainer.builder().name((String)parts.get(parts.size() - 1)).CDNEnabled(Boolean.parseBoolean(cdnEnabled)).ttl(Long.parseLong(cdnTTL)).CDNUri(URI.create(cdnUri)).build();
    }

    @Override
    public ParseCDNContainerFromHeaders setContext(HttpRequest request) {
        this.request = request;
        return this;
    }
}

