/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.TransformingHttpCommand;
import org.jclouds.http.TransformingHttpCommandExecutorService;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class TransformingHttpCommandImpl<T>
implements TransformingHttpCommand<T> {
    protected final TransformingHttpCommandExecutorService executorService;
    protected final Function<HttpResponse, T> transformer;
    protected volatile HttpRequest request;
    protected volatile int failureCount;
    protected volatile int redirectCount;
    protected volatile Exception exception;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    public TransformingHttpCommandImpl(TransformingHttpCommandExecutorService executorService, HttpRequest request, Function<HttpResponse, T> transformer) {
        this.request = Preconditions.checkNotNull(request, "request");
        this.executorService = Preconditions.checkNotNull(executorService, "executorService");
        this.transformer = Preconditions.checkNotNull(transformer, "transformer");
        this.failureCount = 0;
        this.redirectCount = 0;
    }

    @Override
    public ListenableFuture<T> execute() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.executorService.submit(this, this.transformer);
    }

    @Override
    public int getFailureCount() {
        return this.failureCount;
    }

    @Override
    public int incrementFailureCount() {
        return ++this.failureCount;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public int incrementRedirectCount() {
        return ++this.redirectCount;
    }

    @Override
    public int getRedirectCount() {
        return this.redirectCount;
    }

    @Override
    public boolean isReplayable() {
        return this.request.getPayload() == null ? true : this.request.getPayload().isRepeatable();
    }

    @Override
    public HttpRequest getCurrentRequest() {
        return this.request;
    }

    @Override
    public void setCurrentRequest(HttpRequest request) {
        this.request = request;
    }

    public int hashCode() {
        return Objects.hashCode(this.request);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!(that instanceof HttpCommand)) {
            return false;
        }
        return Objects.equal(this.request, ((HttpCommand)HttpCommand.class.cast(that)).getCurrentRequest());
    }

    public String toString() {
        if (this.request instanceof GeneratedHttpRequest) {
            return String.format("[method=%s.%s, request=%s]", ((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(this.request)).getDeclaring().getSimpleName(), ((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(this.request)).getJavaMethod().getName(), this.request.getRequestLine());
        }
        return "[request=" + this.request.getRequestLine() + "]";
    }
}

