/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.services;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.karaf.services.InvalidConfigurationException;
import org.jclouds.karaf.services.internal.ComputeServiceFactory;
import org.jclouds.osgi.ApiListener;
import org.jclouds.osgi.ProviderListener;
import org.jclouds.providers.ProviderMetadata;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceFactorySupport
implements ManagedServiceFactory,
ProviderListener,
ApiListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeServiceFactory.class);
    protected final Map<String, ServiceRegistration> registrations = new ConcurrentHashMap<String, ServiceRegistration>();
    protected final Map<String, Dictionary> pendingPids = new HashMap<String, Dictionary>();
    protected final Map<String, Dictionary> activePids = new HashMap<String, Dictionary>();
    protected final Map<String, String> providerPids = new HashMap<String, String>();
    protected final Map<String, String> apiPids = new HashMap<String, String>();
    protected final Map<String, ProviderMetadata> installedProviders = new HashMap<String, ProviderMetadata>();
    protected final Map<String, ApiMetadata> installedApis = new HashMap<String, ApiMetadata>();

    public abstract boolean apply(ProviderMetadata var1);

    public abstract boolean apply(ApiMetadata var1);

    public synchronized void added(ProviderMetadata provider) {
        if (!this.apply(provider)) {
            return;
        }
        this.installedProviders.put(provider.getId(), provider);
        String pid = this.providerPids.get(provider.getId());
        if (pid != null && this.pendingPids.containsKey(pid)) {
            Dictionary properties = this.pendingPids.get(pid);
            try {
                this.updated(pid, properties);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error while installing service for pending provider " + provider + " with pid " + pid, e);
            }
        }
    }

    public void removed(ProviderMetadata provider) {
        if (!this.apply(provider)) {
            return;
        }
        String pid = this.providerPids.get(provider.getId());
        if (pid != null) {
            if (this.activePids.containsKey(pid)) {
                this.pendingPids.put(pid, this.activePids.remove(pid));
            }
            this.deleted(pid);
        }
        this.installedProviders.remove(provider.getId());
    }

    public void added(ApiMetadata api) {
        if (!this.apply(api)) {
            return;
        }
        this.installedApis.put(api.getId(), api);
        String pid = this.apiPids.get(api.getId());
        if (pid != null && this.pendingPids.containsKey(pid)) {
            Dictionary properties = this.pendingPids.get(pid);
            try {
                this.updated(pid, properties);
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error while installing service for pending api " + api + " with pid " + pid, e);
            }
        }
    }

    public void removed(ApiMetadata api) {
        if (!this.apply(api)) {
            return;
        }
        String pid = this.apiPids.get(api.getId());
        if (pid != null) {
            if (this.activePids.containsKey(pid)) {
                this.pendingPids.put(pid, this.activePids.remove(pid));
            }
            this.deleted(pid);
        }
        this.installedApis.remove(api.getId());
    }

    public void deleted(String pid) {
        ServiceRegistration oldRegistration = this.registrations.remove(pid);
        if (oldRegistration != null) {
            oldRegistration.unregister();
        }
    }

    public static void validate(ProviderMetadata providerMetadata, Dictionary properties) throws InvalidConfigurationException {
        if (Strings.isNullOrEmpty((String)properties.get("identity")) && !providerMetadata.getApiMetadata().getDefaultIdentity().isPresent()) {
            throw new InvalidConfigurationException("No identity specified.");
        }
        if (Strings.isNullOrEmpty((String)properties.get("credential")) && !providerMetadata.getApiMetadata().getDefaultCredential().isPresent()) {
            throw new InvalidConfigurationException("No credential specified specified.");
        }
    }

    public static void validate(ApiMetadata apiMetadata, Dictionary properties) throws InvalidConfigurationException {
        if (Strings.isNullOrEmpty((String)properties.get("identity")) && !apiMetadata.getDefaultIdentity().isPresent()) {
            throw new InvalidConfigurationException("No identity specified.");
        }
        if (Strings.isNullOrEmpty((String)properties.get("credential")) && !apiMetadata.getDefaultCredential().isPresent()) {
            throw new InvalidConfigurationException("No credential specified specified.");
        }
        if (Strings.isNullOrEmpty((String)properties.get("endpoint")) && !apiMetadata.getDefaultEndpoint().isPresent()) {
            throw new InvalidConfigurationException("No credential specified specified.");
        }
    }
}

