/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.config;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import org.jclouds.loadbalancer.strategy.DestroyLoadBalancerStrategy;
import org.jclouds.loadbalancer.strategy.GetLoadBalancerMetadataStrategy;
import org.jclouds.loadbalancer.strategy.ListLoadBalancersStrategy;
import org.jclouds.loadbalancer.strategy.LoadBalanceNodesStrategy;

public abstract class BindLoadBalancerStrategiesByClass
extends AbstractModule {
    @Override
    protected void configure() {
        this.bindLoadBalanceNodesStrategy(this.defineLoadBalanceNodesStrategy());
        this.bindListLoadBalancersStrategy(this.defineListLoadBalancersStrategy());
        this.bindGetLoadBalancerMetadataStrategy(this.defineGetLoadBalancerMetadataStrategy());
        this.bindDestroyLoadBalancerStrategy(this.defineDestroyLoadBalancerStrategy());
    }

    protected void bindLoadBalanceNodesStrategy(Class<? extends LoadBalanceNodesStrategy> clazz) {
        this.bind(LoadBalanceNodesStrategy.class).to(clazz).in(Scopes.SINGLETON);
    }

    protected void bindDestroyLoadBalancerStrategy(Class<? extends DestroyLoadBalancerStrategy> clazz) {
        this.bind(DestroyLoadBalancerStrategy.class).to(clazz).in(Scopes.SINGLETON);
    }

    protected void bindGetLoadBalancerMetadataStrategy(Class<? extends GetLoadBalancerMetadataStrategy> clazz) {
        this.bind(GetLoadBalancerMetadataStrategy.class).to(clazz).in(Scopes.SINGLETON);
    }

    protected void bindListLoadBalancersStrategy(Class<? extends ListLoadBalancersStrategy> clazz) {
        this.bind(ListLoadBalancersStrategy.class).to(clazz).in(Scopes.SINGLETON);
    }

    protected abstract Class<? extends LoadBalanceNodesStrategy> defineLoadBalanceNodesStrategy();

    protected abstract Class<? extends DestroyLoadBalancerStrategy> defineDestroyLoadBalancerStrategy();

    protected abstract Class<? extends GetLoadBalancerMetadataStrategy> defineGetLoadBalancerMetadataStrategy();

    protected abstract Class<? extends ListLoadBalancersStrategy> defineListLoadBalancersStrategy();
}

