/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.domain.Location;
import org.jclouds.domain.internal.ResourceMetadataImpl;
import org.jclouds.loadbalancer.domain.LoadBalancerMetadata;
import org.jclouds.loadbalancer.domain.LoadBalancerType;

public class LoadBalancerMetadataImpl
extends ResourceMetadataImpl<LoadBalancerType>
implements LoadBalancerMetadata {
    private static final long serialVersionUID = 7374704415964898694L;
    private final String id;
    private final LoadBalancerType type;
    private final Set<String> addresses;

    public LoadBalancerMetadataImpl(LoadBalancerType type, String providerId, String name, String id, Location location, URI uri, Map<String, String> userMetadata, Iterable<String> addresses) {
        super(providerId, name, location, uri, userMetadata);
        this.id = Preconditions.checkNotNull(id, "id");
        this.type = Preconditions.checkNotNull(type, "type");
        this.addresses = ImmutableSet.copyOf(Preconditions.checkNotNull(addresses, "addresses"));
    }

    @Override
    public LoadBalancerType getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.addresses == null ? 0 : ((Object)this.addresses).hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "[id=" + this.id + ", providerId=" + this.getProviderId() + ", name=" + this.getName() + ", location=" + this.getLocation() + ", uri=" + this.getUri() + ", userMetadata=" + this.getUserMetadata() + ", type=" + (Object)((Object)this.type) + ", addresses=" + this.addresses + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerMetadataImpl other = (LoadBalancerMetadataImpl)obj;
        if (this.addresses == null ? other.addresses != null : !((Object)this.addresses).equals(other.addresses)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }
}

