/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.cinder.v1.domain.Snapshot;
import org.jclouds.openstack.cinder.v1.options.CreateSnapshotOptions;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.functions.ReturnEmptyFluentIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface SnapshotAsyncApi {
    @GET
    @Path(value="/snapshots")
    @SelectJson(value={"snapshots"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Snapshot>> list();

    @GET
    @Path(value="/snapshots/detail")
    @SelectJson(value={"snapshots"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnEmptyFluentIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends FluentIterable<? extends Snapshot>> listInDetail();

    @GET
    @Path(value="/snapshots/{id}")
    @SelectJson(value={"snapshot"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Snapshot> get(@PathParam(value="id") String var1);

    @POST
    @Path(value="/snapshots")
    @SelectJson(value={"snapshot"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @MapBinder(value=CreateSnapshotOptions.class)
    public ListenableFuture<? extends Snapshot> create(@PayloadParam(value="volume_id") String var1, CreateSnapshotOptions ... var2);

    @DELETE
    @Path(value="/snapshots/{id}")
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    public ListenableFuture<Boolean> delete(@PathParam(value="id") String var1);
}

