/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.config;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jclouds.json.config.GsonModule;

public class KeystoneParserModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind(new TypeLiteral<Set<TypeAdapterFactory>>(){}).toInstance(ImmutableSet.of(new SetTypeAdapterFactory()));
    }

    public static class SetTypeAdapterFactory
    implements TypeAdapterFactory {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Type type = typeToken.getType();
            if (typeToken.getRawType() != Set.class || !(type instanceof ParameterizedType)) {
                return null;
            }
            Type elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
            TypeAdapter<?> elementAdapter = gson.getAdapter(TypeToken.get(elementType));
            return (TypeAdapter)TypeAdapter.class.cast(this.newSetAdapter(elementAdapter));
        }

        private <E> TypeAdapter<Set<E>> newSetAdapter(final TypeAdapter<E> elementAdapter) {
            return new TypeAdapter<Set<E>>(){

                @Override
                public void write(JsonWriter out, Set<E> value) throws IOException {
                    out.beginArray();
                    for (Object element : value) {
                        elementAdapter.write(out, element);
                    }
                    out.endArray();
                }

                @Override
                public Set<E> read(JsonReader in) throws IOException {
                    LinkedHashSet result = Sets.newLinkedHashSet();
                    if (in.peek() == JsonToken.BEGIN_OBJECT) {
                        boolean foundValues = false;
                        in.beginObject();
                        while (in.hasNext()) {
                            String name = in.nextName();
                            if (Objects.equal("values", name)) {
                                foundValues = true;
                                this.readArray(in, result);
                                continue;
                            }
                            in.skipValue();
                        }
                        Preconditions.checkState(foundValues, "Expected BEGIN_ARRAY or the object to contain an array called 'values'");
                        in.endObject();
                    } else {
                        this.readArray(in, result);
                    }
                    return result;
                }

                private void readArray(JsonReader in, Set<E> result) throws IOException {
                    in.beginArray();
                    while (in.hasNext()) {
                        Object element = elementAdapter.read(in);
                        result.add(element);
                    }
                    in.endArray();
                }
            }.nullSafe();
        }
    }
}

