/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.collect.PagedIterable;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.functions.ReturnEmptyPaginatedCollectionOnNotFoundOr404;
import org.jclouds.openstack.keystone.v2_0.functions.internal.ParseTenants;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.functions.ReturnEmptyPagedIterableOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@Endpoint(value=Identity.class)
public interface TenantAsyncApi {
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseTenants.class)
    @Transform(value=ParseTenants.ToPagedIterable.class)
    @ExceptionParser(value=ReturnEmptyPagedIterableOnNotFoundOr404.class)
    public ListenableFuture<? extends PagedIterable<? extends Tenant>> list();

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ResponseParser(value=ParseTenants.class)
    @ExceptionParser(value=ReturnEmptyPaginatedCollectionOnNotFoundOr404.class)
    public ListenableFuture<? extends PaginatedCollection<? extends Tenant>> list(PaginationOptions var1);

    @GET
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @Path(value="/tenants/{tenantId}")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> get(@PathParam(value="tenantId") String var1);

    @GET
    @SelectJson(value={"tenant"})
    @Consumes(value={"application/json"})
    @Path(value="/tenants")
    @RequestFilters(value={AuthenticateRequest.class})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Tenant> getByName(@QueryParam(value="name") String var1);
}

