/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.config;

import com.google.common.base.Supplier;
import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.functions.URIFromAuthenticationResponseForService;
import org.jclouds.openstack.nova.NovaAsyncClient;
import org.jclouds.openstack.nova.NovaClient;
import org.jclouds.openstack.nova.ServerManagement;
import org.jclouds.openstack.nova.handlers.ParseNovaErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class NovaRestClientModule
extends RestClientModule<NovaClient, NovaAsyncClient> {
    private final OpenStackAuthenticationModule module;

    public NovaRestClientModule(OpenStackAuthenticationModule module) {
        this.module = module;
    }

    public NovaRestClientModule() {
        this(new OpenStackAuthenticationModule());
    }

    @Override
    protected void configure() {
        this.install(this.module);
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseNovaErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseNovaErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseNovaErrorFromHttpResponse.class);
    }

    @Provides
    @Singleton
    @ServerManagement
    protected Supplier<URI> provideServerUrl(URIFromAuthenticationResponseForService.Factory factory) {
        return factory.create("X-Server-Management-Url");
    }
}

