/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.domain.Resource;

public class Flavor
extends Resource {
    private final String name;
    private final Integer disk;
    private final Integer ram;
    private final Integer vcpus;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFlavor(this);
    }

    @ConstructorProperties(value={"id", "links", "orderedSelfReferences", "name", "disk", "ram", "vcpus"})
    protected Flavor(int id, List<Map<String, String>> links, @Nullable Map<Resource.LinkType, URI> orderedSelfReferences, @Nullable String name, @Nullable Integer disk, @Nullable Integer ram, @Nullable Integer vcpus) {
        super(id, links, orderedSelfReferences);
        this.name = name;
        this.disk = disk;
        this.ram = ram;
        this.vcpus = vcpus;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getDisk() {
        return this.disk;
    }

    @Nullable
    public Integer getRam() {
        return this.ram;
    }

    @Nullable
    public Integer getVcpus() {
        return this.vcpus;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.name, this.disk, this.ram, this.vcpus);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Flavor that = (Flavor)Flavor.class.cast(obj);
        return super.equals(that) && Objects.equal(this.name, that.name) && Objects.equal(this.disk, that.disk) && Objects.equal(this.ram, that.ram) && Objects.equal(this.vcpus, that.vcpus);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("name", this.name).add("disk", this.disk).add("ram", this.ram).add("vcpus", this.vcpus);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String name;
        protected Integer disk;
        protected Integer ram;
        protected Integer vcpus;

        public T name(String name) {
            this.name = name;
            return (T)((Builder)this.self());
        }

        public T disk(Integer disk) {
            this.disk = disk;
            return (T)((Builder)this.self());
        }

        public T ram(Integer ram) {
            this.ram = ram;
            return (T)((Builder)this.self());
        }

        public T vcpus(Integer vcpus) {
            this.vcpus = vcpus;
            return (T)((Builder)this.self());
        }

        public Flavor build() {
            return new Flavor(this.id, this.links, this.orderedSelfReferences, this.name, this.disk, this.ram, this.vcpus);
        }

        public T fromFlavor(Flavor in) {
            return ((Builder)((Builder)((Builder)((Builder)super.fromResource(in)).name(in.getName())).disk(in.getDisk())).ram(in.getRam())).vcpus(in.getVcpus());
        }
    }
}

