/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.openstack.nova.domain.Resource;

public class FloatingIP
extends Resource {
    private final String ip;
    private final String fixedIP;
    private final int instanceID;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFloatingIP(this);
    }

    @ConstructorProperties(value={"id", "links", "orderedSelfReferences", "ip", "fixed_ip", "instance_id"})
    protected FloatingIP(int id, List<Map<String, String>> links, Map<Resource.LinkType, URI> orderedSelfReferences, String ip, String fixedIP, int instanceID) {
        super(id, links, orderedSelfReferences);
        this.ip = Preconditions.checkNotNull(ip, "ip");
        this.fixedIP = Preconditions.checkNotNull(fixedIP, "fixedIP");
        this.instanceID = instanceID;
    }

    public String getIp() {
        return this.ip;
    }

    public String getFixedIP() {
        return this.fixedIP;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.ip, this.fixedIP, this.instanceID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingIP that = (FloatingIP)FloatingIP.class.cast(obj);
        return super.equals(that) && Objects.equal(this.ip, that.ip) && Objects.equal(this.fixedIP, that.fixedIP) && Objects.equal(this.instanceID, that.instanceID);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("ip", this.ip).add("fixedIP", this.fixedIP).add("instanceID", this.instanceID);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String ip;
        protected String fixedIP;
        protected int instanceID;

        public T ip(String ip) {
            this.ip = ip;
            return (T)((Builder)this.self());
        }

        public T fixedIP(String fixedIP) {
            this.fixedIP = fixedIP;
            return (T)((Builder)this.self());
        }

        public T instanceID(int instanceID) {
            this.instanceID = instanceID;
            return (T)((Builder)this.self());
        }

        public FloatingIP build() {
            return new FloatingIP(this.id, this.links, this.orderedSelfReferences, this.ip, this.fixedIP, this.instanceID);
        }

        public T fromFloatingIP(FloatingIP in) {
            return ((Builder)((Builder)((Builder)super.fromResource(in)).ip(in.getIp())).fixedIP(in.getFixedIP())).instanceID(in.getInstanceID());
        }
    }
}

