/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.ec2.loaders;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.loaders.CreateSecurityGroupIfNeeded;

@Singleton
public class NovaCreateSecurityGroupIfNeeded
extends CreateSecurityGroupIfNeeded {
    @Inject
    public NovaCreateSecurityGroupIfNeeded(EC2Client ec2Client, @Named(value="SECURITY") Predicate<RegionAndName> securityGroupEventualConsistencyDelay) {
        super(Preconditions.checkNotNull(ec2Client, "ec2Client").getSecurityGroupServices(), securityGroupEventualConsistencyDelay);
    }

    @Override
    protected void authorizeGroupToItself(String region, String name) {
        try {
            super.authorizeGroupToItself(region, name);
        }
        catch (AWSResponseException e) {
            this.logger.warn(e, "<< error authorizing securityGroup(%s)", name);
        }
    }
}

