/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.keystone.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.features.FlavorApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseFlavorDetails
extends ParseJson<Flavors<? extends Flavor>> {
    @Inject
    public ParseFlavorDetails(Json json) {
        super(json, new TypeLiteral<Flavors<? extends Flavor>>(){});
    }

    public static class ToPagedIterable
    extends CallerArg0ToPagedIterable<Flavor, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = Preconditions.checkNotNull(api, "api");
        }

        @Override
        protected Function<Object, IterableWithMarker<Flavor>> markerToNextForCallingArg0(String zone) {
            final FlavorApi flavorApi = this.api.getFlavorApiForZone(zone);
            return new Function<Object, IterableWithMarker<Flavor>>(){

                @Override
                public IterableWithMarker<Flavor> apply(Object input) {
                    return (IterableWithMarker)IterableWithMarker.class.cast(flavorApi.listInDetail(PaginationOptions.Builder.marker(input.toString())));
                }

                public String toString() {
                    return "listFlavorsInDetail()";
                }
            };
        }
    }

    static class Flavors<T extends Flavor>
    extends PaginatedCollection<T> {
        @ConstructorProperties(value={"flavors", "flavors_links"})
        protected Flavors(Iterable<T> flavors, Iterable<Link> flavors_links) {
            super(flavors, flavors_links);
        }
    }
}

