/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.jclouds.logging.Logger;
import org.jclouds.util.Throwables2;

public class RetryableNumTimesPredicate<T>
implements Predicate<T> {
    private final int maxAttempts;
    private final long period;
    private final long maxPeriod;
    private final Predicate<T> predicate;
    @Resource
    protected Logger logger = Logger.NULL;

    public RetryableNumTimesPredicate(Predicate<T> predicate, int maxAttempts, long period, long maxPeriod, TimeUnit unit) {
        this.predicate = Preconditions.checkNotNull(predicate);
        this.maxAttempts = maxAttempts;
        this.period = unit.toMillis(period);
        this.maxPeriod = unit.toMillis(maxPeriod);
        Preconditions.checkArgument(maxAttempts >= 0, "maxAttempts must be greater than zero, but was " + maxAttempts);
        Preconditions.checkArgument(period >= 0L, "period must be greater than zero, but was " + period);
        Preconditions.checkArgument(maxPeriod >= 0L, "maxPeriod must be greater than zero, but was " + maxPeriod);
        Preconditions.checkArgument(maxPeriod >= period, "maxPeriod must be greater than or equal to period, but was " + maxPeriod + " < " + period);
    }

    public RetryableNumTimesPredicate(Predicate<T> predicate, int maxAttempts, long period, TimeUnit unit) {
        this(predicate, maxAttempts, period, period * 10L, unit);
    }

    public RetryableNumTimesPredicate(Predicate<T> predicate, int maxAttempts) {
        this(predicate, maxAttempts, 50L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean apply(T input) {
        try {
            int i = 1;
            while (i <= this.maxAttempts) {
                if (this.predicate.apply(input)) {
                    return true;
                }
                Thread.sleep(this.nextMaxInterval(i++));
            }
            return false;
        }
        catch (InterruptedException e) {
            this.logger.warn(e, "predicate %s on %s interrupted, returning false", input, this.predicate);
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            if (Throwables2.getFirstThrowableOfType(e, ExecutionException.class) != null) {
                this.logger.warn(e, "predicate %s on %s errored [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(e, IllegalStateException.class) != null) {
                this.logger.warn(e, "predicate %s on %s illegal state [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(e, CancellationException.class) != null) {
                this.logger.warn(e, "predicate %s on %s cancelled [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(e, TimeoutException.class) != null) {
                this.logger.warn(e, "predicate %s on %s timed out [%s], returning false", input, this.predicate, e.getMessage());
                return false;
            }
            throw e;
        }
        return false;
    }

    protected long nextMaxInterval(long attempt) {
        long interval = (long)((double)this.period * Math.pow(1.5, attempt - 1L));
        return interval > this.maxPeriod ? this.maxPeriod : interval;
    }
}

