/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.rackspace.cloudidentity.v2_0.config.CloudIdentityAuthenticationModule;
import org.jclouds.rackspace.cloudloadbalancers.CloudLoadBalancersApi;
import org.jclouds.rackspace.cloudloadbalancers.CloudLoadBalancersAsyncApi;
import org.jclouds.rackspace.cloudloadbalancers.config.CloudLoadBalancersRestClientModule;
import org.jclouds.rackspace.cloudloadbalancers.loadbalancer.config.CloudLoadBalancersLoadBalancerContextModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class CloudLoadBalancersApiMetadata
extends BaseRestApiMetadata {
    public static final TypeToken<RestContext<CloudLoadBalancersApi, CloudLoadBalancersAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<CloudLoadBalancersApi, CloudLoadBalancersAsyncApi>>(){};

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public CloudLoadBalancersApiMetadata() {
        this(new Builder());
    }

    protected CloudLoadBalancersApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "rax:load-balancer");
        properties.setProperty("jclouds.keystone.credential-type", "RAX-KSKEY:apiKeyCredentials");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(CloudLoadBalancersApi.class, CloudLoadBalancersAsyncApi.class);
            ((BaseApiMetadata.Builder)this.id("cloudloadbalancers").name("Rackspace Cloud Load Balancers API").identityName("Username").credentialName("API Key").documentation(URI.create("http://docs.rackspace.com/loadbalancers/api/clb-devguide-latest/index.html")).version("1.0").defaultEndpoint("https://identity.api.rackspacecloud.com/v2.0/").defaultProperties(CloudLoadBalancersApiMetadata.defaultProperties()).view(TypeToken.of(LoadBalancerServiceContext.class))).defaultModules(ImmutableSet.of(CloudIdentityAuthenticationModule.class, KeystoneAuthenticationModule.ZoneModule.class, CloudLoadBalancersRestClientModule.class, CloudLoadBalancersLoadBalancerContextModule.class));
        }

        @Override
        public CloudLoadBalancersApiMetadata build() {
            return new CloudLoadBalancersApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

