/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.domain;

import com.google.common.base.Objects;
import org.jclouds.rackspace.cloudloadbalancers.domain.internal.BaseLoadBalancer;

public class LoadBalancerAttributes {
    protected String name;
    protected String protocol;
    protected Integer port;
    protected String algorithm;

    public LoadBalancerAttributes name(String name) {
        this.name = name;
        return this;
    }

    public LoadBalancerAttributes protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public LoadBalancerAttributes port(int port) {
        this.port = port;
        return this;
    }

    public LoadBalancerAttributes algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public static <T extends BaseLoadBalancer<?, T>> LoadBalancerAttributes fromLoadBalancer(T lb) {
        return Builder.name(lb.getName()).port(lb.getPort()).protocol(lb.getProtocol()).algorithm(lb.getAlgorithm());
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("name", this.name).add("algorithm", this.algorithm).add("port", this.port).add("protocol", this.protocol);
    }

    public String toString() {
        return this.string().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.algorithm, this.port, this.protocol);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LoadBalancerAttributes that = (LoadBalancerAttributes)LoadBalancerAttributes.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.algorithm, that.algorithm) && Objects.equal(this.port, that.port) && Objects.equal(this.protocol, that.protocol);
    }

    public static class Builder {
        public static LoadBalancerAttributes name(String name) {
            return new LoadBalancerAttributes().name(name);
        }

        public static LoadBalancerAttributes protocol(String protocol) {
            return new LoadBalancerAttributes().protocol(protocol);
        }

        public static LoadBalancerAttributes port(int port) {
            return new LoadBalancerAttributes().port(port);
        }

        public static LoadBalancerAttributes algorithm(String algorithm) {
            return new LoadBalancerAttributes().algorithm(algorithm);
        }
    }
}

