/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rackspace.cloudloadbalancers.domain.LoadBalancer;
import org.jclouds.rackspace.cloudloadbalancers.functions.ConvertLB;
import org.jclouds.rackspace.cloudloadbalancers.functions.LB;
import org.jclouds.rest.InvocationContext;

public class ParseLoadBalancer
implements Function<HttpResponse, LoadBalancer>,
InvocationContext<ParseLoadBalancer> {
    private final ParseJson<Map<String, LB>> json;
    private final ConvertLB.Factory factory;
    private ConvertLB convertLB;

    @Inject
    ParseLoadBalancer(ParseJson<Map<String, LB>> json, ConvertLB.Factory factory) {
        this.json = Preconditions.checkNotNull(json, "json");
        this.factory = Preconditions.checkNotNull(factory, "factory");
    }

    @Override
    public LoadBalancer apply(HttpResponse arg0) {
        Preconditions.checkState(this.convertLB != null, "convertLB should be set by InvocationContext");
        Map<String, LB> map = this.json.apply(arg0);
        if (map == null || map.size() == 0) {
            return null;
        }
        LB lb = Iterables.get(map.values(), 0);
        return this.convertLB.apply(lb);
    }

    @Override
    public ParseLoadBalancer setContext(HttpRequest request) {
        return this.setRegion(request.getEndpoint().getHost().substring(0, request.getEndpoint().getHost().indexOf(46)));
    }

    ParseLoadBalancer setRegion(String region) {
        this.convertLB = this.factory.createForRegion(region);
        return this;
    }
}

