/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.functions;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.internal.ClassMethodArgsAndReturnVal;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@Singleton
@Beta
public class PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion
implements ImplicitOptionalConverter {
    private final LoadingCache<ClassMethodArgsAndReturnVal, Optional<Object>> lookupCache;

    @Inject
    protected PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion(@ApiVersion String apiVersion) {
        this.lookupCache = CacheBuilder.newBuilder().build(new Loader(apiVersion));
    }

    @Override
    public Optional<Object> apply(ClassMethodArgsAndReturnVal input) {
        return this.lookupCache.getUnchecked(input);
    }

    @VisibleForTesting
    static final class Loader
    extends CacheLoader<ClassMethodArgsAndReturnVal, Optional<Object>> {
        private final String apiVersion;

        @Inject
        Loader(@ApiVersion String apiVersion) {
            this.apiVersion = Preconditions.checkNotNull(apiVersion, "apiVersion");
        }

        @Override
        public Optional<Object> load(ClassMethodArgsAndReturnVal input) {
            Optional<SinceApiVersion> sinceApiVersion = Optional.fromNullable(input.getClazz().getAnnotation(SinceApiVersion.class));
            if (sinceApiVersion.isPresent()) {
                String since = sinceApiVersion.get().value();
                if (since.compareTo(this.apiVersion) <= 0) {
                    return Optional.of(input.getReturnVal());
                }
                return Optional.absent();
            }
            return Optional.of(input.getReturnVal());
        }
    }
}

