/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.internal.BaseApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.concurrent.Timeout;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.rimuhosting.miro.RimuHostingAsyncClient;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.compute.config.RimuHostingComputeServiceContextModule;
import org.jclouds.rimuhosting.miro.config.RimuHostingRestClientModule;

public class RimuHostingApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = 6725672099385580694L;
    public static final TypeToken<RestContext<RimuHostingClient, RimuHostingAsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<RimuHostingClient, RimuHostingAsyncClient>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder().fromApiMetadata(this);
    }

    public RimuHostingApiMetadata() {
        this(new Builder());
    }

    protected RimuHostingApiMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        Timeout timeout = RimuHostingClient.class.getAnnotation(Timeout.class);
        long timeoutMillis = timeout.timeUnit().toMillis(timeout.duration());
        properties.setProperty("jclouds.so-timeout", timeoutMillis + "");
        properties.setProperty("jclouds.connection-timeout", timeoutMillis + "");
        properties.setProperty("jclouds.compute.timeout.node-terminated", "60000");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder() {
            super(RimuHostingClient.class, RimuHostingAsyncClient.class);
            ((BaseApiMetadata.Builder)this.id("rimuhosting").name("RimuHosting API").identityName("API Key").documentation(URI.create("http://apidocs.rimuhosting.com")).version("1").defaultEndpoint("https://api.rimuhosting.com/r").defaultProperties(RimuHostingApiMetadata.defaultProperties()).view(TypeToken.of(ComputeServiceContext.class))).defaultModules(ImmutableSet.of(RimuHostingRestClientModule.class, RimuHostingComputeServiceContextModule.class));
        }

        @Override
        public RimuHostingApiMetadata build() {
            return new RimuHostingApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

