/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.rimuhosting.miro.compute.functions.RimuHostingImageToImage;
import org.jclouds.rimuhosting.miro.compute.functions.ServerToNodeMetadata;
import org.jclouds.rimuhosting.miro.compute.strategy.RimuHostingComputeServiceAdapter;
import org.jclouds.rimuhosting.miro.domain.Image;
import org.jclouds.rimuhosting.miro.domain.Server;
import org.jclouds.rimuhosting.miro.domain.internal.RunningState;

public class RimuHostingComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Server, Hardware, Image, Location> {
    @VisibleForTesting
    static final Map<RunningState, NodeMetadata.Status> runningStateToNodeStatus = ImmutableMap.builder().put(RunningState.RUNNING, NodeMetadata.Status.RUNNING).put(RunningState.NOTRUNNING, NodeMetadata.Status.SUSPENDED).put(RunningState.POWERCYCLING, NodeMetadata.Status.PENDING).put(RunningState.RESTARTING, NodeMetadata.Status.PENDING).put(RunningState.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<Server, Hardware, Image, Location>>(){}).to(RimuHostingComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<Server, Iterable<String>>>(){}).to(ServerToPublicAddresses.class);
        this.bind(new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(RimuHostingImageToImage.class);
        this.bind(new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind(new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
    }

    @Singleton
    @Provides
    Map<RunningState, NodeMetadata.Status> provideServerToNodeStatus() {
        return runningStateToNodeStatus;
    }

    @Singleton
    private static class ServerToPublicAddresses
    implements Function<Server, Iterable<String>> {
        private ServerToPublicAddresses() {
        }

        @Override
        public Iterable<String> apply(Server server) {
            return server.getIpAddresses() == null ? ImmutableSet.of() : Iterables.concat(ImmutableList.of(server.getIpAddresses().getPrimaryIp()), server.getIpAddresses().getSecondaryIps());
        }
    }
}

