/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.rimuhosting.miro.domain.Server;
import org.jclouds.rimuhosting.miro.domain.internal.RunningState;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final Supplier<Set<? extends Location>> locations;
    protected final Function<Server, Iterable<String>> getPublicAddresses;
    protected final Map<RunningState, NodeMetadata.Status> runningStateToNodeStatus;
    protected final Supplier<Set<? extends Image>> images;
    protected final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerToNodeMetadata(Function<Server, Iterable<String>> getPublicAddresses, @Memoized Supplier<Set<? extends Location>> locations, Map<RunningState, NodeMetadata.Status> runningStateToNodeStatus, @Memoized Supplier<Set<? extends Image>> images, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.getPublicAddresses = Preconditions.checkNotNull(getPublicAddresses, "serverStateToNodeStatus");
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.runningStateToNodeStatus = Preconditions.checkNotNull(runningStateToNodeStatus, "serverStateToNodeStatus");
        this.images = Preconditions.checkNotNull(images, "images");
    }

    @Override
    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        builder.hostname(from.getName());
        Location location = this.findLocationWithId(from.getLocation().getId());
        builder.location(location);
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.imageId(from.getImageId() + "");
        builder.operatingSystem(this.parseOperatingSystem(from, location));
        builder.hardware(null);
        if (from.getBillingData() != null && from.getBillingData().getDateCancelled() != null && RunningState.NOTRUNNING == from.getState()) {
            builder.status(NodeMetadata.Status.TERMINATED);
        } else {
            builder.status(this.runningStateToNodeStatus.get((Object)from.getState()));
        }
        builder.publicAddresses(this.getPublicAddresses.apply(from));
        return builder.build();
    }

    private Location findLocationWithId(final String locationId) {
        try {
            Location location = Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

                @Override
                public boolean apply(Location input) {
                    return input.getId().equals(locationId);
                }
            });
            return location;
        }
        catch (NoSuchElementException e) {
            this.logger.debug("couldn't match instance location %s in: %s", locationId, this.locations.get());
            return null;
        }
    }

    protected OperatingSystem parseOperatingSystem(Server from, Location location) {
        try {
            return Iterables.find((Iterable)this.images.get(), new FindImageForServer(location, from)).getOperatingSystem();
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching image for server %s in location %s", from, location);
            return null;
        }
    }

    private static class FindImageForServer
    implements Predicate<Image> {
        private final Location location;
        private final Server instance;

        private FindImageForServer(Location location, Server instance) {
            this.location = location;
            this.instance = instance;
        }

        @Override
        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImageId()) && (input.getLocation() == null || input.getLocation().equals(this.location) || input.getLocation().equals(this.location.getParent()));
        }
    }
}

