/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.binder.CreateServerOptions;
import org.jclouds.rimuhosting.miro.domain.Image;
import org.jclouds.rimuhosting.miro.domain.NewServerResponse;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;
import org.jclouds.rimuhosting.miro.domain.Server;
import org.jclouds.util.Iterables2;

@Singleton
public class RimuHostingComputeServiceAdapter
implements ComputeServiceAdapter<Server, Hardware, Image, Location> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final RimuHostingClient client;
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    protected RimuHostingComputeServiceAdapter(RimuHostingClient client, @Memoized Supplier<Set<? extends Location>> locations) {
        this.client = Preconditions.checkNotNull(client, "client");
        this.locations = Preconditions.checkNotNull(locations, "locations");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Server> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        NewServerResponse server = this.client.createServer(name, Preconditions.checkNotNull(template.getImage().getProviderId(), "imageId"), Preconditions.checkNotNull(template.getHardware().getProviderId(), "hardwareId"), new CreateServerOptions[0]);
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Server>(server.getServer(), server.getServer().getId() + "", LoginCredentials.builder().password(server.getNewInstanceRequest().getCreateOptions().getPassword()).build());
    }

    @Override
    public Iterable<Hardware> listHardwareProfiles() {
        HashSet<Hardware> sizes = Sets.newHashSet();
        for (final PricingPlan pricingPlan : this.client.getPricingPlanList()) {
            try {
                Location location = Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

                    @Override
                    public boolean apply(Location input) {
                        return input.getId().equals(pricingPlan.getDataCenter().getId());
                    }
                });
                sizes.add(new HardwareBuilder().ids(pricingPlan.getId()).location(location).processors(ImmutableList.of(new Processor(1.0, 1.0))).ram(pricingPlan.getRam()).volumes(ImmutableList.of(new VolumeImpl(Float.valueOf(pricingPlan.getDiskSize().intValue()), true, true))).build());
            }
            catch (NullPointerException e) {
                this.logger.warn("datacenter not present in " + pricingPlan.getId(), new Object[0]);
            }
        }
        return sizes;
    }

    @Override
    public Iterable<Image> listImages() {
        return Iterables2.concreteCopy(this.client.getImageList());
    }

    @Override
    public Iterable<Server> listNodes() {
        return Iterables2.concreteCopy(this.client.getServerList());
    }

    @Override
    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    @Override
    public Server getNode(String id) {
        long serverId = Long.parseLong(id);
        return this.client.getServer(serverId);
    }

    @Override
    public Image getImage(final String id) {
        return Iterables.find(this.listImages(), new Predicate<Image>(){

            @Override
            public boolean apply(Image input) {
                return input.getId().equals(id);
            }
        }, null);
    }

    @Override
    public void destroyNode(String id) {
        Long serverId = Long.parseLong(id);
        this.client.destroyServer(serverId);
    }

    @Override
    public void rebootNode(String id) {
        Long serverId = Long.parseLong(id);
        this.client.restartServer(serverId).getState();
    }

    @Override
    public void resumeNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    @Override
    public void suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }
}

