/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.domain;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import org.jclouds.rimuhosting.miro.data.NewServerData;
import org.jclouds.rimuhosting.miro.domain.BillingData;
import org.jclouds.rimuhosting.miro.domain.DataCenter;
import org.jclouds.rimuhosting.miro.domain.DataTransferAllowance;
import org.jclouds.rimuhosting.miro.domain.IpAddresses;
import org.jclouds.rimuhosting.miro.domain.MetaData;
import org.jclouds.rimuhosting.miro.domain.ServerParameters;
import org.jclouds.rimuhosting.miro.domain.internal.RunningState;

public class Server
implements Comparable<Server> {
    @SerializedName(value="allocated_ips")
    private IpAddresses ipAddresses;
    @SerializedName(value="billing_oid")
    private Long billingId;
    @SerializedName(value="data_transfer_allowance")
    private DataTransferAllowance allowance;
    @SerializedName(value="distro")
    private String imageId;
    @SerializedName(value="domain_name")
    private String name;
    @SerializedName(value="host_server_oid")
    private String hostServerId;
    @SerializedName(value="is_on_customers_own_physical_server")
    private Boolean onDedicatedHardware;
    @SerializedName(value="order_oid")
    private Long id;
    @SerializedName(value="running_state")
    private RunningState state;
    @SerializedName(value="server_type")
    private String type;
    private String slug;
    @SerializedName(value="vps_parameters")
    private ServerParameters serverParameters;
    @SerializedName(value="billing_info")
    private BillingData billingData;
    private DataCenter location;
    @SerializedName(value="meta_data")
    private List<MetaData> metaData;
    private transient NewServerData serverDataRequest;

    public IpAddresses getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(IpAddresses ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public Long getBillingId() {
        return this.billingId;
    }

    public void setBillingId(Long billingId) {
        this.billingId = billingId;
    }

    public DataTransferAllowance getAllowance() {
        return this.allowance;
    }

    public void setAllowance(DataTransferAllowance allowance) {
        this.allowance = allowance;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHostServerId() {
        return this.hostServerId;
    }

    public void setHostServerId(String hostServerId) {
        this.hostServerId = hostServerId;
    }

    public Boolean isOnDedicatedHardware() {
        return this.onDedicatedHardware;
    }

    public void setOnDedicatedHardware(Boolean onDedicatedHardware) {
        this.onDedicatedHardware = onDedicatedHardware;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public RunningState getState() {
        return this.state;
    }

    public void setState(RunningState state) {
        this.state = state;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public ServerParameters getInstanceParameters() {
        return this.serverParameters;
    }

    public void setInstanceParameters(ServerParameters serverParameters) {
        this.serverParameters = serverParameters;
    }

    public NewServerData getInstanceRequest() {
        return this.serverDataRequest;
    }

    public void setInstanceRequest(NewServerData serverDataRequest) {
        this.serverDataRequest = serverDataRequest;
    }

    @Override
    public int compareTo(Server server) {
        return this.name.compareTo(server.getName());
    }

    public void setLocation(DataCenter location) {
        this.location = location;
    }

    public DataCenter getLocation() {
        return this.location;
    }

    public void setMetaData(List<MetaData> metaData) {
        this.metaData = metaData;
    }

    public List<MetaData> getMetaData() {
        return this.metaData;
    }

    public Boolean getOnDedicatedHardware() {
        return this.onDedicatedHardware;
    }

    public BillingData getBillingData() {
        return this.billingData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

