/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53;

import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.Route53AsyncApi;
import org.jclouds.route53.config.Route53RestClientModule;

public class Route53ApiMetadata
extends BaseRestApiMetadata {
    public static final TypeToken<RestContext<? extends Route53Api, ? extends Route53AsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<? extends Route53Api, ? extends Route53AsyncApi>>(){
        private static final long serialVersionUID = 1L;
    };

    @Override
    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata(this);
    }

    public Route53ApiMetadata() {
        this(new Builder(Route53Api.class, Route53AsyncApi.class));
    }

    protected Route53ApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)Builder.class.cast(builder));
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("route53").name("Amazon Route 53 Api").identityName("Access Key ID").credentialName("Secret Access Key").version("2012-02-29").documentation(URI.create("http://docs.aws.amazon.com/Route53/latest/APIReference/")).defaultEndpoint("https://route53.amazonaws.com").defaultProperties(Route53ApiMetadata.defaultProperties()).defaultModule(Route53RestClientModule.class);
        }

        @Override
        public Route53ApiMetadata build() {
            return new Route53ApiMetadata(this);
        }

        @Override
        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

