/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.features;

import com.google.common.util.concurrent.ListenableFuture;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.collect.PagedIterable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.route53.binders.BindChangeBatch;
import org.jclouds.route53.binders.BindNextRecord;
import org.jclouds.route53.domain.Change;
import org.jclouds.route53.domain.ChangeBatch;
import org.jclouds.route53.domain.RecordSet;
import org.jclouds.route53.domain.RecordSetIterable;
import org.jclouds.route53.filters.RestAuthentication;
import org.jclouds.route53.functions.RecordSetIterableToPagedIterable;
import org.jclouds.route53.functions.SerializeRRS;
import org.jclouds.route53.xml.ChangeHandler;
import org.jclouds.route53.xml.ListResourceRecordSetsResponseHandler;

@RequestFilters(value={RestAuthentication.class})
@VirtualHost
@Path(value="/{jclouds.api-version}/hostedzone/{zoneId}")
public interface RecordSetAsyncApi {
    @Named(value="ChangeResourceRecordSets")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/rrset")
    @Payload(value="<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><ChangeBatch><Changes><Change><Action>CREATE</Action>{rrs}</Change></Changes></ChangeBatch></ChangeResourceRecordSetsRequest>")
    @XMLResponseParser(value=ChangeHandler.class)
    public ListenableFuture<Change> create(@PayloadParam(value="rrs") @ParamParser(value=SerializeRRS.class) RecordSet var1);

    @Named(value="ChangeResourceRecordSets")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/rrset")
    @XMLResponseParser(value=ChangeHandler.class)
    public ListenableFuture<Change> apply(@BinderParam(value=BindChangeBatch.class) ChangeBatch var1);

    @Named(value="ListResourceRecordSets")
    @GET
    @Path(value="/rrset")
    @XMLResponseParser(value=ListResourceRecordSetsResponseHandler.class)
    @Transform(value=RecordSetIterableToPagedIterable.class)
    public ListenableFuture<PagedIterable<RecordSet>> list();

    @Named(value="ListResourceRecordSets")
    @GET
    @Path(value="/rrset")
    @XMLResponseParser(value=ListResourceRecordSetsResponseHandler.class)
    public ListenableFuture<RecordSetIterable> listFirstPage();

    @Named(value="ListResourceRecordSets")
    @GET
    @Path(value="/rrset")
    @XMLResponseParser(value=ListResourceRecordSetsResponseHandler.class)
    public ListenableFuture<RecordSetIterable> listAt(@BinderParam(value=BindNextRecord.class) RecordSetIterable.NextRecord var1);

    @Named(value="ChangeResourceRecordSets")
    @POST
    @Produces(value={"application/xml"})
    @Path(value="/rrset")
    @Payload(value="<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2012-02-29/\"><ChangeBatch><Changes><Change><Action>DELETE</Action>{rrs}</Change></Changes></ChangeBatch></ChangeResourceRecordSetsRequest>")
    @XMLResponseParser(value=ChangeHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Change> delete(@PayloadParam(value="rrs") @ParamParser(value=SerializeRRS.class) RecordSet var1);
}

