/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.RecordSet;
import org.jclouds.route53.domain.RecordSetIterable;
import org.jclouds.route53.features.RecordSetApi;

@Beta
public class RecordSetIterableToPagedIterable
extends CallerArg0ToPagedIterable<RecordSet, RecordSetIterableToPagedIterable> {
    private final Route53Api api;

    @Inject
    protected RecordSetIterableToPagedIterable(Route53Api api) {
        this.api = Preconditions.checkNotNull(api, "api");
    }

    @Override
    protected Function<Object, IterableWithMarker<RecordSet>> markerToNextForCallingArg0(String zoneId) {
        final RecordSetApi resourceRecordSetApi = this.api.getRecordSetApiForZone(zoneId);
        return new Function<Object, IterableWithMarker<RecordSet>>(){

            @Override
            public IterableWithMarker<RecordSet> apply(Object input) {
                return resourceRecordSetApi.listAt((RecordSetIterable.NextRecord)RecordSetIterable.NextRecord.class.cast(input));
            }

            public String toString() {
                return "listResourceRecordSets()";
            }
        };
    }
}

