/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.NewZone;
import org.jclouds.route53.domain.ZoneAndNameServers;
import org.jclouds.route53.xml.ChangeHandler;
import org.jclouds.route53.xml.GetHostedZoneResponseHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class CreateHostedZoneResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<NewZone> {
    private final GetHostedZoneResponseHandler zoneHandler;
    private final ChangeHandler changeHandler;
    private boolean inChange;

    @Inject
    public CreateHostedZoneResponseHandler(GetHostedZoneResponseHandler zoneHandler, ChangeHandler changeHandler) {
        this.zoneHandler = zoneHandler;
        this.changeHandler = changeHandler;
    }

    @Override
    public NewZone getResult() {
        ZoneAndNameServers zone = this.zoneHandler.getResult();
        return NewZone.create(zone, this.changeHandler.getResult());
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix(qName, "ChangeInfo")) {
            this.inChange = true;
        }
        if (this.inChange) {
            this.changeHandler.startElement(url, name, qName, attributes);
        } else {
            this.zoneHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.inChange) {
            if (qName.equals("ChangeInfo")) {
                this.inChange = false;
            } else {
                this.changeHandler.endElement(uri, name, qName);
            }
        } else {
            this.zoneHandler.endElement(uri, name, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inChange) {
            this.changeHandler.characters(ch, start, length);
        } else {
            this.zoneHandler.characters(ch, start, length);
        }
    }
}

