/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.route53.domain.Zone;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ZoneHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Zone> {
    private StringBuilder currentText = new StringBuilder();
    private Zone.Builder builder = Zone.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Zone getResult() {
        try {
            Zone zone = this.builder.build();
            return zone;
        }
        finally {
            this.builder = Zone.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Id")) {
            this.builder.id(SaxUtils.currentOrNull(this.currentText).replace("/hostedzone/", ""));
        } else if (qName.equals("Name")) {
            this.builder.name(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("CallerReference")) {
            this.builder.callerReference(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("Comment")) {
            this.builder.comment(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("ResourceRecordSetCount")) {
            this.builder.resourceRecordSetCount(Integer.parseInt(SaxUtils.currentOrNull(this.currentText)));
        }
        this.currentText = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

