/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.AccessControlList;

@Singleton
public class BindACLToXMLPayload
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        AccessControlList from = (AccessControlList)payload;
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        try {
            String stringPayload = this.generateBuilder(from).asString(outputProperties);
            request.setPayload(stringPayload);
            request.getPayload().getContentMetadata().setContentType("text/xml");
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw new RuntimeException("error transforming acl: " + from, e);
        }
        return request;
    }

    protected XMLBuilder generateBuilder(AccessControlList acl) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("AccessControlPolicy").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (acl.getOwner() != null) {
            XMLBuilder ownerBuilder = rootBuilder.elem("Owner");
            ownerBuilder.elem("ID").text(acl.getOwner().getId()).up();
            if (acl.getOwner().getDisplayName() != null) {
                ownerBuilder.elem("DisplayName").text(acl.getOwner().getDisplayName()).up();
            }
        }
        XMLBuilder grantsBuilder = rootBuilder.elem("AccessControlList");
        for (AccessControlList.Grant grant : acl.getGrants()) {
            XMLBuilder grantBuilder = grantsBuilder.elem("Grant");
            XMLBuilder granteeBuilder = grantBuilder.elem("Grantee").attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (grant.getGrantee() instanceof AccessControlList.GroupGrantee) {
                granteeBuilder.attr("xsi:type", "Group").elem("URI").text(grant.getGrantee().getIdentifier());
            } else if (grant.getGrantee() instanceof AccessControlList.CanonicalUserGrantee) {
                AccessControlList.CanonicalUserGrantee grantee = (AccessControlList.CanonicalUserGrantee)grant.getGrantee();
                granteeBuilder.attr("xsi:type", "CanonicalUser").elem("ID").text(grantee.getIdentifier()).up();
                if (grantee.getDisplayName() != null) {
                    granteeBuilder.elem("DisplayName").text(grantee.getDisplayName());
                }
            } else if (grant.getGrantee() instanceof AccessControlList.EmailAddressGrantee) {
                granteeBuilder.attr("xsi:type", "AmazonCustomerByEmail").elem("EmailAddress").text(grant.getGrantee().getIdentifier());
            }
            grantBuilder.elem("Permission").text(grant.getPermission().toString());
        }
        return grantsBuilder;
    }
}

