/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;
import org.jclouds.softlayer.SoftLayerApiMetadata;

public class SoftLayerProviderMetadata
extends BaseProviderMetadata {
    private static final long serialVersionUID = 2196535609684739834L;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return SoftLayerProviderMetadata.builder().fromProviderMetadata(this);
    }

    public SoftLayerProviderMetadata() {
        super(SoftLayerProviderMetadata.builder());
    }

    public SoftLayerProviderMetadata(Builder builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("jclouds.softlayer.virtualguest.order-delay", "3600000");
        properties.setProperty("jclouds.softlayer.virtualguest.package-name", "Cloud Server");
        properties.setProperty("jclouds.softlayer.virtualguest.cpu-regex", "[0-9]+ x ([0-9.]+) GHz Core[s]?");
        properties.setProperty("jclouds.softlayer.virtualguest.disk0-type", "LOCAL");
        properties.setProperty("jclouds.softlayer.virtualguest.port-speed", "10");
        ImmutableSet.Builder prices = ImmutableSet.builder();
        prices.add("21");
        prices.add("55");
        prices.add("57");
        prices.add("58");
        prices.add("1800");
        prices.add("905");
        prices.add("418");
        prices.add("420");
        properties.setProperty("jclouds.softlayer.virtualguest.prices", Joiner.on(',').join(prices.build()));
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,osVersionMatches=1[012].[01][04],os64Bit=true,osDescriptionMatches=.*Minimal Install.*");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("softlayer").name("SoftLayer").apiMetadata(new SoftLayerApiMetadata()).homepage(URI.create("http://www.softlayer.com")).console(URI.create("https://manage.softlayer.com")).iso3166Codes("SG", "US-CA", "US-TX", "US-VA", "US-WA", "US-TX").endpoint("https://api.softlayer.com/rest").defaultProperties(SoftLayerProviderMetadata.defaultProperties());
        }

        @Override
        public SoftLayerProviderMetadata build() {
            return new SoftLayerProviderMetadata(this);
        }

        @Override
        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

