/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.ProductOrder;

public class ProductOrderReceipt {
    private final int orderId;
    private final ProductOrder orderDetails;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromProductOrderReceipt(this);
    }

    @ConstructorProperties(value={"orderId", "orderDetails"})
    protected ProductOrderReceipt(int orderId, @Nullable ProductOrder orderDetails) {
        this.orderId = orderId;
        this.orderDetails = orderDetails;
    }

    public int getOrderId() {
        return this.orderId;
    }

    @Nullable
    public ProductOrder getOrderDetails() {
        return this.orderDetails;
    }

    public int hashCode() {
        return Objects.hashCode(this.orderId, this.orderDetails);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductOrderReceipt that = (ProductOrderReceipt)ProductOrderReceipt.class.cast(obj);
        return Objects.equal(this.orderId, that.orderId) && Objects.equal(this.orderDetails, that.orderDetails);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("orderId", this.orderId).add("orderDetails", this.orderDetails);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int orderId;
        protected ProductOrder orderDetails;

        protected abstract T self();

        public T orderId(int orderId) {
            this.orderId = orderId;
            return this.self();
        }

        public T orderDetails(ProductOrder orderDetails) {
            this.orderDetails = orderDetails;
            return this.self();
        }

        public ProductOrderReceipt build() {
            return new ProductOrderReceipt(this.orderId, this.orderDetails);
        }

        public T fromProductOrderReceipt(ProductOrderReceipt in) {
            return ((Builder)this.orderId(in.getOrderId())).orderDetails(in.getOrderDetails());
        }
    }
}

