/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.options;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ReceiveMessageOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Integer visibilityTimeout;
    private ImmutableSet.Builder<String> attributes = ImmutableSet.builder();

    public ReceiveMessageOptions visibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
        return this;
    }

    public ReceiveMessageOptions attributes(Iterable<String> attributes) {
        this.attributes = ImmutableSet.builder().addAll(attributes);
        return this;
    }

    public ReceiveMessageOptions attribute(String attribute) {
        this.attributes.add((Object)attribute);
        return this;
    }

    @Override
    public Multimap<String, String> buildFormParameters() {
        ImmutableCollection attributes;
        Multimap<String, String> params = super.buildFormParameters();
        if (this.visibilityTimeout != null) {
            params.put("VisibilityTimeout", this.visibilityTimeout.toString());
        }
        if ((attributes = this.attributes.build()).size() > 0) {
            int nameIndex = 1;
            for (String attribute : attributes) {
                params.put("AttributeName." + nameIndex, attribute);
                ++nameIndex;
            }
        }
        return params;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.visibilityTimeout, this.attributes.build());
    }

    public ReceiveMessageOptions clone() {
        return new ReceiveMessageOptions().visibilityTimeout(this.visibilityTimeout).attributes(this.attributes.build());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiveMessageOptions other = (ReceiveMessageOptions)ReceiveMessageOptions.class.cast(obj);
        return Objects.equal(this.visibilityTimeout, other.visibilityTimeout) && Objects.equal(this.attributes.build(), other.attributes.build());
    }

    @Override
    public String toString() {
        ImmutableCollection attributes = this.attributes.build();
        return Objects.toStringHelper(this).omitNullValues().add("visibilityTimeout", this.visibilityTimeout).add("attributes", attributes.size() > 0 ? attributes : null).toString();
    }

    public static class Builder {
        public static ReceiveMessageOptions visibilityTimeout(Integer visibilityTimeout) {
            return new ReceiveMessageOptions().visibilityTimeout(visibilityTimeout);
        }

        public static ReceiveMessageOptions attribute(String attribute) {
            return new ReceiveMessageOptions().attribute(attribute);
        }

        public static ReceiveMessageOptions attributes(Iterable<String> attributes) {
            return new ReceiveMessageOptions().attributes(attributes);
        }
    }
}

