/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

public class Capacity {
    private final String units;
    private final long allocated;
    private final long limit;
    private final int used;
    private final long overhead;

    public Capacity(String units, long allocated, long limit, int used, long overhead) {
        this.units = units;
        this.limit = limit;
        this.allocated = allocated;
        this.used = used;
        this.overhead = overhead;
    }

    public String getUnits() {
        return this.units;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public long getLimit() {
        return this.limit;
    }

    public int getUsed() {
        return this.used;
    }

    public long getOverhead() {
        return this.overhead;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.allocated ^ this.allocated >>> 32);
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + (int)(this.overhead ^ this.overhead >>> 32);
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        result = 31 * result + this.used;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Capacity other = (Capacity)obj;
        if (this.allocated != other.allocated) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.overhead != other.overhead) {
            return false;
        }
        if (this.units == null ? other.units != null : !this.units.equals(other.units)) {
            return false;
        }
        return this.used == other.used;
    }

    public String toString() {
        return "[allocated=" + this.allocated + ", limit=" + this.limit + ", overhead=" + this.overhead + ", units=" + this.units + ", used=" + this.used + "]";
    }
}

