/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.domain;

import com.google.common.base.Objects;
import org.jclouds.trmk.vcloud_0_8.domain.Subnet;

public class NetworkAdapter
implements Comparable<NetworkAdapter> {
    private final String macAddress;
    private final String name;
    private final Subnet subnet;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkAdapter.builder().fromNetworkAdapter(this);
    }

    public NetworkAdapter(String macAddress, String name, Subnet subnet) {
        this.macAddress = macAddress;
        this.name = name;
        this.subnet = subnet;
    }

    @Override
    public int compareTo(NetworkAdapter that) {
        return this == that ? 0 : this.getMacAddress().compareTo(that.getMacAddress());
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getName() {
        return this.name;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAdapter that = (NetworkAdapter)NetworkAdapter.class.cast(o);
        return Objects.equal(this.macAddress, that.macAddress) && Objects.equal(this.name, that.name) && Objects.equal(this.subnet, that.subnet);
    }

    public int hashCode() {
        return Objects.hashCode(this.macAddress, this.name, this.subnet);
    }

    public String toString() {
        return Objects.toStringHelper("").add("macAddress", this.macAddress).add("name", this.name).add("subnet", this.subnet).toString();
    }

    public static class Builder {
        private String macAddress;
        private String name;
        private Subnet subnet;

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        public NetworkAdapter build() {
            return new NetworkAdapter(this.macAddress, this.name, this.subnet);
        }

        public Builder fromNetworkAdapter(NetworkAdapter in) {
            return this.macAddress(in.getMacAddress()).name(in.getName()).subnet(in.getSubnet());
        }
    }
}

