/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.endpoints.VDC;

@Singleton
public class DefaultVDC
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locationsSupplier;
    private final IsDefaultVDC isDefaultVDC;

    @Inject
    DefaultVDC(@Memoized Supplier<Set<? extends Location>> locationsSupplier, IsDefaultVDC isDefaultVDC) {
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplierSupplier");
        this.isDefaultVDC = Preconditions.checkNotNull(isDefaultVDC, "isDefaultVDC");
    }

    @Override
    public Location get() {
        return Iterables.find((Iterable)this.locationsSupplier.get(), this.isDefaultVDC);
    }

    @Singleton
    public static final class IsDefaultVDC
    implements Predicate<Location> {
        private final Supplier<ReferenceType> defaultVDC;

        @Inject
        IsDefaultVDC(@VDC Supplier<ReferenceType> defaultVDC) {
            this.defaultVDC = Preconditions.checkNotNull(defaultVDC, "defaultVDC");
        }

        @Override
        public boolean apply(Location input) {
            return input.getScope() == LocationScope.ZONE && input.getId().equals(this.defaultVDC.get().getHref().toASCIIString());
        }

        public String toString() {
            return "isDefaultVDC()";
        }
    }
}

