/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloud_0_8.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;

public class OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault
implements Function<Iterable<ReferenceType>, ReferenceType> {
    protected final ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull;
    protected final String configurationKey;
    protected final Predicate<ReferenceType> defaultSelector;

    public OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, String configurationKey, Predicate<ReferenceType> defaultSelector) {
        this.configurationKey = Preconditions.checkNotNull(configurationKey, "configurationKey");
        this.valueOfConfigurationKeyOrNull = Preconditions.checkNotNull(valueOfConfigurationKeyOrNull, "valueOfConfigurationKeyOrNull");
        this.defaultSelector = Preconditions.checkNotNull(defaultSelector, "defaultSelector");
    }

    @Override
    public ReferenceType apply(Iterable<ReferenceType> referenceTypes) {
        Preconditions.checkNotNull(referenceTypes, "referenceTypes");
        Preconditions.checkArgument(Iterables.size(referenceTypes) > 0, "No referenceTypes corresponding to configuration key %s present", this.configurationKey);
        if (Iterables.size(referenceTypes) == 1) {
            return Iterables.getLast(referenceTypes);
        }
        String namingPattern = this.valueOfConfigurationKeyOrNull.apply(this.configurationKey);
        if (namingPattern != null) {
            return this.findReferenceTypeWithNameMatchingPattern(referenceTypes, namingPattern);
        }
        return this.defaultReferenceType(referenceTypes);
    }

    public ReferenceType defaultReferenceType(Iterable<ReferenceType> referenceTypes) {
        return Iterables.find(referenceTypes, this.defaultSelector);
    }

    public ReferenceType findReferenceTypeWithNameMatchingPattern(Iterable<ReferenceType> referenceTypes, String namingPattern) {
        try {
            return Iterables.find(referenceTypes, new ReferenceTypeNameMatchesPattern(namingPattern));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("referenceType matching pattern [%s], corresponding to configuration key %s, not in %s", namingPattern, this.configurationKey, referenceTypes));
        }
    }

    static class ReferenceTypeNameMatchesPattern
    implements Predicate<ReferenceType> {
        private final String namingPattern;

        public ReferenceTypeNameMatchesPattern(String namingPattern) {
            this.namingPattern = Preconditions.checkNotNull(namingPattern, "namingPattern");
        }

        @Override
        public boolean apply(ReferenceType arg0) {
            return arg0.getName().matches(this.namingPattern);
        }

        public String toString() {
            return "nameMatchesPattern(" + this.namingPattern + ")";
        }
    }
}

