/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.firewall;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.firewall.FirewallPolicy;
import org.jclouds.vcloud.domain.network.firewall.FirewallProtocols;

public class FirewallRule {
    private final boolean enabled;
    @Nullable
    private final String description;
    @Nullable
    private final FirewallPolicy policy;
    @Nullable
    private final FirewallProtocols protocols;
    private final int port;
    private final String destinationIp;

    public FirewallRule(boolean enabled, @Nullable String description, @Nullable FirewallPolicy policy, @Nullable FirewallProtocols protocols, int port, String destinationIp) {
        this.enabled = enabled;
        this.description = description;
        this.policy = policy;
        this.protocols = protocols;
        this.port = port;
        this.destinationIp = Preconditions.checkNotNull(destinationIp, "destinationIp");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public FirewallPolicy getPolicy() {
        return this.policy;
    }

    @Nullable
    public FirewallProtocols getProtocols() {
        return this.protocols;
    }

    public int getPort() {
        return this.port;
    }

    public String getDestinationIp() {
        return this.destinationIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FirewallRule that = (FirewallRule)FirewallRule.class.cast(o);
        return Objects.equal(this.enabled, that.enabled) && Objects.equal(this.description, that.description) && Objects.equal((Object)this.policy, (Object)that.policy) && Objects.equal(this.protocols, that.protocols) && Objects.equal(this.port, that.port) && Objects.equal(this.destinationIp, that.destinationIp);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.enabled, this.description, this.policy, this.protocols, this.port, this.destinationIp});
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("enabled", this.enabled).add("description", this.description).add("policy", (Object)this.policy).add("protocols", this.protocols).add("port", this.port).add("destinationIp", this.destinationIp).toString();
    }
}

