/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat.rules;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.NatRule;

public class PortForwardingRule
implements NatRule {
    private final String externalIP;
    private final int externalPort;
    private final String internalIP;
    private final int internalPort;
    private final NatProtocol protocol;

    public PortForwardingRule(String externalIP, int externalPort, String internalIP, int internalPort, NatProtocol protocol) {
        this.externalIP = Preconditions.checkNotNull(externalIP, "externalIP");
        this.externalPort = externalPort;
        this.internalIP = Preconditions.checkNotNull(internalIP, "internalIP");
        this.internalPort = internalPort;
        this.protocol = Preconditions.checkNotNull(protocol, "protocol");
    }

    @Override
    public String getExternalIP() {
        return this.externalIP;
    }

    public int getExternalPort() {
        return this.externalPort;
    }

    public String getInternalIP() {
        return this.internalIP;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public NatProtocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortForwardingRule that = (PortForwardingRule)PortForwardingRule.class.cast(o);
        return Objects.equal(this.externalIP, that.externalIP) && Objects.equal(this.externalPort, that.externalPort) && Objects.equal(this.internalIP, that.internalIP) && Objects.equal(this.internalPort, that.internalPort) && Objects.equal((Object)this.protocol, (Object)that.protocol);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.externalIP, this.externalPort, this.internalIP, this.internalPort, this.protocol});
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("externalIP", this.externalIP).add("externalPort", this.externalPort).add("internalIP", this.internalIP).add("internalPort", this.internalPort).add("protocol", (Object)this.protocol).toString();
    }
}

