/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat.rules;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.NatRule;

public class VmRule
implements NatRule {
    @Nullable
    private final String externalIP;
    private final int externalPort;
    @Nullable
    private final String vAppScopedLocalId;
    private final int vmNicId;
    private final int internalPort;
    private final NatProtocol protocol;

    public VmRule(@Nullable String externalIP, int externalPort, @Nullable String vAppScopedLocalId, int vmNicId, int internalPort, NatProtocol protocol) {
        this.externalIP = externalIP;
        this.externalPort = externalPort;
        this.vAppScopedLocalId = vAppScopedLocalId;
        this.vmNicId = vmNicId;
        this.internalPort = internalPort;
        this.protocol = Preconditions.checkNotNull(protocol, "protocol");
    }

    @Override
    @Nullable
    public String getExternalIP() {
        return this.externalIP;
    }

    public Integer getExternalPort() {
        return this.externalPort;
    }

    @Nullable
    public String getVAppScopedLocalId() {
        return this.vAppScopedLocalId;
    }

    public int getVmNicId() {
        return this.vmNicId;
    }

    public Integer getInternalPort() {
        return this.internalPort;
    }

    public NatProtocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmRule that = (VmRule)VmRule.class.cast(o);
        return Objects.equal(this.externalIP, that.externalIP) && Objects.equal(this.externalPort, that.externalPort) && Objects.equal(this.vAppScopedLocalId, that.vAppScopedLocalId) && Objects.equal(this.vmNicId, that.vmNicId) && Objects.equal(this.internalPort, that.internalPort) && Objects.equal((Object)this.protocol, (Object)that.protocol);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.externalIP, this.externalPort, this.vAppScopedLocalId, this.vmNicId, this.internalPort, this.protocol});
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("externalIP", this.externalIP).add("externalPort", this.externalPort).add("vAppScopedLocalId", this.vAppScopedLocalId).add("vmNicId", this.vmNicId).add("internalPort", this.internalPort).add("protocol", (Object)this.protocol).toString();
    }
}

